/*****************************************************************************
**  chBinWriter.hpp
**
**      chBinWriter is a chWriter which writes binary chunk files.
**
**	Gigawatt Studios
**	Copyright(C) 2001 - All Rights Reserved
\****************************************************************************/

#ifdef CH_BINWRITER_HPP
#error chBinWriter.hpp multiply included
#endif
#define CH_BINWRITER_HPP

#ifndef CH_WRITER_HPP
#include "chWriter.hpp"
#endif

#include <stack>
#include <vector>

class fsFileStream;

class chBinWriter : public chWriter
{
	public:

		//====================================================================
		//====================================================================
		chBinWriter(fsFileStream& io_File);

		//====================================================================
		//====================================================================
		virtual ~chBinWriter();

		//====================================================================
		//	WriteChunkHeader writes a chunk header in the file at the
		//	current position.
		//====================================================================
		virtual void WriteChunkHeader(	chDefs::Name i_Name, 
										chDefs::Version i_Version, 
										bool i_Container);

		//====================================================================
		//	FinishChunk will cause the writer to compute the size of the 
		//	chunk and finish writing the header.
		//====================================================================
		virtual void FinishChunk();

		//====================================================================
		//	Write functions - These write the data to the chunk file.
		//====================================================================
		virtual void Write(envType::Int8 i_Val);
		virtual void Write(envType::UInt8 i_Val);
		virtual void Write(envType::Int16 i_Val);
		virtual void Write(envType::UInt16 i_Val);
		virtual void Write(envType::Int32 i_Val);
		virtual void Write(envType::UInt32 i_Val);
		virtual void Write(envType::Int64 i_Val);
		virtual void Write(envType::UInt64 i_Val);
		virtual void Write(envType::Float32 i_Val);
		virtual void Write(envType::Float64 i_Val);

		//====================================================================
		//	This Write writes a bool value.
		//====================================================================
		virtual void Write(bool i_Val);

		//====================================================================
		//	This Write writes a NULL-terminated single-byte character string.
		//	It will write the NULL into the file.
		//====================================================================
		virtual void Write(const char* i_Val);

		//====================================================================
		//	This Write writes a single-byte character string with a length
		//	given by i_Length.  It does not write the length into the file;
		//	you must do that yourself.
		//====================================================================
		virtual void Write(const char* i_Val, int i_Length);

		//====================================================================
		//	This Write writes a NULL-terminated Unicode character string.  It
		//	will write the NULL into the file.
		//====================================================================
		virtual void Write(const envType::UInt16* i_Val);

		//====================================================================
		//	This Write writes a Unicode character string with a length
		//	given by i_Length.  It does not write the length into the file;
		//	you must do that yourself.
		//====================================================================
		virtual void Write(const envType::UInt16* i_Val, int i_Length);

		//====================================================================
		//	Write chunk of binary data; this is only for
		//	chBinWriter, it is not a function of chWriter base class
		//====================================================================
		virtual	void Write(const void* i_Data, int i_NumBytes);

		//========================================================================
		//	GetLocator returns this file's associated locator
		//========================================================================
		const std::string& GetLocator() const;

	private:

		fsFileStream& m_File;
		std::stack<int, std::vector<int> > m_HeaderLocs;
};

